﻿using System;
using System.Diagnostics;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.OnDemand
{
    /// <summary>
    /// Set the Meeting Room Name Step. 
    /// </summary>
    public class SetMeetingRoomNameStep : FilterBase<VmrOnDemandCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VmrOnDemandCreateStateObject state)
        {
            var continueFindingNumber = true;
            string proposedName;
            var timer = Stopwatch.StartNew();
            var depth = 0;

            do
            {
                var randomDigit = RandomDigits.GetRandomDigitString(7);
                depth++;

                proposedName = $"{state.VirtualMeetingRoomPrefix}{randomDigit}";

                using (var context = new Xrm(state.OrganizationServiceProxy))
                {
                    Logger.Instance.Debug($"Progress: Beginning VOD Step. Took {timer.ElapsedMilliseconds} ms");

                    var dateHundredDaysAgo = state.AppointmentStartDate.Subtract(new TimeSpan(100, 0, 0, 0));

                    var match = context.cvt_vodSet.FirstOrDefault(x =>
                        x.Id != state.VideoOnDemandId &&
                        x.cvt_meetingroomname != null &&
                        x.cvt_starttime >= dateHundredDaysAgo &&
                        x.cvt_starttime <= state.AppointmentStartDate &&
                        x.cvt_meetingroomname == proposedName);

                    Logger.Instance.Debug($"Progress: Retrieved All VOD Appointments. Took {timer.ElapsedMilliseconds} ms");

                    if (match == null) continueFindingNumber = false;
                }
            } while (continueFindingNumber);

            if (string.IsNullOrEmpty(proposedName)) throw new Exception("Unable to generate VOD name");

            state.MeetingRoomName = proposedName;

            Logger.Instance.Debug($"Progress: Generated unique Meeting Room Name - {state.MeetingRoomName}. Took {timer.ElapsedMilliseconds} ms with {depth} try(s)");
            timer.Stop();
        }
    }
}